/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	PartOpen.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CFile.h"
#include "CApplication.h"

//  Open the part with the specified name and return the part
HRESULT PartOpen(CString fileName,IPartDocument **part) 
{
	START_METHOD("PartOpen")

	HRESULT status = CONV_SUCCESS;
	IApplication *pdApplication = NULL;

	// Get the application
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	// open the part
	IPartDocument *pDisp = NULL;
	BSTR fName = fileName.AllocSysString(); 
	status = pdApplication->OpenPart(fName,&pDisp);
	CHECK_RETURN_STATUS(status)

	*part = pDisp;
	
	END_METHOD("PartOpen")
}
